/*****************************************************************************
 * $Id$
 *
 * Project:		NXP LPC11xx Secondary Bootloader Example
 *
 * Description: Provides access to In-Application Programming (IAP) routines
 * 			    contained within the bootROM sector of LPC11xx devices.
 *
 * Copyright(C) 2010, NXP Semiconductor
 * All rights reserved.
 *
 *****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
#ifndef __EEPROM_H
#define	__EEPROM_H

#include <stdint.h>



uint32_t u32EEPROM_WRITE(uint32_t u32DstAddr, uint32_t u32SrcAddr, uint32_t u32Len);
uint32_t u32EEPROM_READ(uint32_t u32SrcAddr, uint32_t u32DstAddr, uint32_t u32Len);

#endif /* end __EEPROM_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
